Imports MPQ_API
Imports System.Threading

Public Class frmMain
    Dim MyProgrammer As New MPQ_API.MPQ_API
    Private PortStatusUB(4) As Byte

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub btTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btTest.Click
        btTest.Enabled = False

        Dim ists As UInt32, t As Thread
        ists = MyProgrammer.Open("COM3")        ' open COM port to programmer(s)
        If ists <> MPQ_API.MPQ_API.STS_SUCCESS Then
            DisplayMessage(ists, "Failed to Open Programmer")
            btTest.Enabled = True
            Exit Sub
        End If

        ists = MyProgrammer.SelectProgrammer(1) 'select programmer address 1
        If ists <> MPQ_API.MPQ_API.STS_SUCCESS Then
            DisplayMessage(ists, "Failed to Open Programmer")
            MyProgrammer.Close()
            btTest.Enabled = True
            Exit Sub
        End If

        ists = MyProgrammer.PortEnables(MPQ_API.MPQ_API.bm_PORTALL) 'enable all ports
        If ists <> MPQ_API.MPQ_API.STS_SUCCESS Then
            DisplayMessage(ists, "Failed Port Enable")
            MyProgrammer.Close()
            btTest.Enabled = True
            Exit Sub
        End If

        ists = MyProgrammer.Program(1)  'initiate programming with Image 1
        If ists <> MPQ_API.MPQ_API.STS_SUCCESS Then
            DisplayMessage(ists, "Failed Programming Initiation")
            MyProgrammer.Close()
            btTest.Enabled = True
            Exit Sub
        End If


        t = New Thread(AddressOf PollStatus)    'start a thread to poll status
        t.Start()
        Do
            Thread.Sleep(250)   ' update the status display every so often
            tbStatus1.Text = MyProgrammer.StatusDecode(PortStatusUB(1))
            tbStatus2.Text = MyProgrammer.StatusDecode(PortStatusUB(2))
            tbStatus3.Text = MyProgrammer.StatusDecode(PortStatusUB(3))
            tbStatus4.Text = MyProgrammer.StatusDecode(PortStatusUB(4))
            Me.Refresh()
        Loop Until PortStatusUB(0) = 0
        btTest.Enabled = True
        MyProgrammer.Close()
    End Sub
    Private Sub DisplayMessage(ByVal ists As UInt32, ByVal ErrStr As String)
        Dim i As UInt32
        i = MsgBox("Error " & Str(ists) & vbCrLf & ErrStr)
    End Sub
    Private Sub PollStatus()
        Dim ists As UInt32

        '* Poll port statuses occasionally until programmer is no longer busy
        Do
            Thread.Sleep(100)
            ists = MyProgrammer.Status(PortStatusUB)    'read ports status
            If ists <> MPQ_API.MPQ_API.STS_SUCCESS Then
                Exit Sub   'bail on error
            End If
        Loop Until PortStatusUB(0) = 0
    End Sub

End Class
